#!/usr/bin/wish

# wdisplay.tcl
# show vector w values

proc fileRecv {fd} {
  global sam

  # read 4*sam bytes (sam values) into list l
  set r [read $fd [expr 4*$sam]]

  # detect eof only after read!
  if {[eof $fd]} {
    puts "fileRecv eof"
    close $fd
    return
  }

  binary scan $r "f$sam" l

  # linear Scale
  set yscale [expr 1.0]

  # erase canvas
  .ca delete ttt

  set x 0
  foreach y $l {
    set y [expr 99 - $y * $yscale]
    .ca create line $x 100 $x $y -tags ttt
    incr x
  }
}

proc UserOpen {fd chost cport} {
  fconfigure $fd -translation binary -encoding binary
  fileevent $fd readable [list fileRecv $fd]
}

# ##############################################################
# main

# check Programm Args
if {$argc < 1} {
  puts "usage: wdisplay.tcl samples"
  exit
}

set sam [lindex $argv 0]   ;# vector length - see aec.cpp
# puts "sam =$sam"

# create a canvas to draw the graphical objects on
canvas .ca -width $sam -height 200
pack .ca

# Open Server part of TCP connection
socket -server UserOpen 50999
