/* testdenoise.c
 * Jean-Marc Valin, www.speex.org
 * Changes Andre Adrian
 *
 
cc -O2 -o testdenoise testdenoise.c -lm -lspeex

 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <speex/speex_preprocess.h>
#include <stdio.h>

#define NN 160

typedef signed short MONO;

typedef struct {
  signed short l;
  signed short r;
} STEREO;

int main()
{
   STEREO in[NN];
   MONO inm[NN];
   int i;
   SpeexPreprocessState *st;
   int count=0;
   float f;

   st = speex_preprocess_state_init(NN, 8000);
   i=1;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_DENOISE, &i);
   i=0;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_AGC, &i);
   f=8000;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_AGC_LEVEL, &f);
   i=0;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_DEREVERB, &i);
   f=.4;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_DEREVERB_DECAY, &f);
   f=.3;
   speex_preprocess_ctl(st, SPEEX_PREPROCESS_SET_DEREVERB_LEVEL, &f);
   while (1)
   {
      int vad;
      fread(in, sizeof(STEREO), NN, stdin);
      for (i = 0; i < NN; ++i) {
        inm[i] = in[i].l;
      }
      
      if (feof(stdin))
         break;
      vad = speex_preprocess(st, inm, NULL);
      /*fprintf (stderr, "%d\n", vad);*/
      for (i = 0; i < NN; ++i) {
        in[i].l = inm[i];
      }
      fwrite(in, sizeof(STEREO), NN, stdout);
      count++;
   }
   speex_preprocess_state_destroy(st);
   return 0;
}
