#include "signature.h"

void init_signature_bits() {
  bzero(signature, sizeof(signature));
}

void init_signature1_bits() {
  bzero(signature1, sizeof(signature1));
}

void init_signature2_bits() {
  bzero(signature2, sizeof(signature2));
}

int get_signature_bit(int n) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature_bit(): index out of range\n");
#endif

  return (signature[byte] & (1 << bit)) >> bit;
}

int get_signature1_bit(int n) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature1_bit(): index out of range\n");
#endif

  return (signature1[byte] & (1 << bit)) >> bit;
}

int get_signature2_bit(int n) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature2_bit(): index out of range\n");
#endif

  return (signature2[byte] & (1 << bit)) >> bit;
}

void set_signature_bit(int n, int v) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature_bit(): index out of range\n");
#endif

  if (v)
    signature[byte] |= (1 << bit);
  else
    signature[byte] &= ~(1 << bit);
}

void set_signature1_bit(int n, int v) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature1_bit(): index out of range\n");
#endif

  if (v)
    signature1[byte] |= (1 << bit);
  else
    signature1[byte] &= ~(1 << bit);
}

void set_signature2_bit(int n, int v) {
  int byte = n >> 3;
  int bit = n & 7;

#ifdef DEBUG
  if (byte < 0 || byte >= NSIGNATURE)
    fprintf(stderr, "get_signature2_bit(): index out of range\n");
#endif

  if (v)
    signature2[byte] |= (1 << bit);
  else
    signature2[byte] &= ~(1 << bit);
}

